<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->get('/health/db', function () use ($router) {
    $results = [];

    // Default connection
    try {
        app('db')->connection()->getPdo();
        $results['default'] = 'connected';
    } catch (\Exception $e) {
        app('log')->error('DB default connection failed: '.$e->getMessage());
        $results['default'] = 'error';
    }

    // Admin connection (configured via DB_ADMIN_ env vars)
    try {
        app('db')->connection('admin')->getPdo();
        $results['admin'] = 'connected';
    } catch (\Exception $e) {
        app('log')->error('DB admin connection failed: '.$e->getMessage());
        $results['admin'] = 'error';
    }

    $status = in_array('error', $results, true) ? 500 : 200;

    return response()->json(['databases' => $results], $status);
});
