window.headers = {
    Accept: "application/json",
    "Content-Type": "application/json",
};

window.headers_multi = {
    "Content-Type": "multipart/form-data",
};

window.endpointWS = process.env.MIX_WS_ADMINISTRADOR;

window.notification = (icon, title, text) => {
    /* window.Swal.fire({
        allowOutsideClick: false,
        icon: icon,
        title: title,
        text: text,
    }); */
    window.Swal.fire({
        allowOutsideClick: false,
        allowEscapeKey: false,
        title: title,
        text: text,
        icon: icon,
        buttonsStyling: false,
        customClass: {
            confirmButton: "btn btn-success",
            cancelButton: "btn btn-danger",
        },
    });
};

window.listarDatatableSimple = (url, table, columns) => {
    $(`#${table}`).DataTable({
        autoWidth: false,
        serverSide: true,
        responsive: false,
        ordering: false,
        destroy: true,
        //processing: true,
        lengthChange: false,
        //dom: 'frtip',
        //buttons: ["copy", "excel", "pdf", "print", "colvis"],
        ajax: {
            url: url,
            type: "GET",
        },
        columns: columns,
    });
}

window.listarDatatable = (url, table, columns, columns_export) => {

    $(`#${table}`).DataTable({
        autoWidth: false,
        serverSide: true,
        responsive: true,
        ordering: false,
        destroy: true,
        //processing: true,
        lengthChange: false,
        dom: 'Bfrtip',
        //buttons: ["copy", "excel", "pdf", "print", "colvis"],
        buttons: [{
                extend: "copy",
                exportOptions: {
                    columns: columns_export
                },
            },
            {
                extend: "excel",
                exportOptions: {
                    columns: columns_export
                },
            },
            {
                extend: "pdf",
                exportOptions: {
                    columns: columns_export
                }
            },
            {
                extend: "print",
                exportOptions: {
                    columns: columns_export
                },
            },
        ],
        /* language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.16/i18n/Spanish.json"
        }, */
        ajax: {
            url: url,
            type: "GET",
        },
        columns: columns,
    });
};

window.listarDatatableWs = (data, table, columns, columns_export) => {
    //console.log("entro a wsdatatable");
    $(`#${table}`).DataTable({
        autoWidth: false,
        responsive: true,
        ordering: false,
        //processing: true,
        lengthChange: false,
        dom: 'Bfrtip',
        buttons: [{
                extend: "copy",
                exportOptions: {
                    columns: columns_export
                },
            },
            {
                extend: "excel",
                exportOptions: {
                    columns: columns_export
                },
            },
            {
                extend: "pdf",
                exportOptions: {
                    columns: columns_export
                }
            },
            {
                extend: "print",
                exportOptions: {
                    columns: columns_export
                },
            },
        ],
        data: data,
        columns: columns,
        pageLength: 25,
    });
};


window.loading = () => {
    notification("info", "Espere", "Procesando Información.");
    return Swal.showLoading();
};

window.anyError = () => {
    return notification(
        "error",
        "Error!",
        "Ocurrio un error en el sistema, por favor contacta con soporte!"
    );
};

window.validationError = (errors) => {
    let datali = "";
    for (const property in errors) {
        if (errors[property].length > 1) {
            for (property2 in errors[property]) {
                //window.toastr.error(errors[property][property2]);
                datali += errors[property][property2];
            }
        } else {
            //window.toastr.error(errors[property][0]);
            datali += errors[property][0] + "</br>";
        }
    }
    return notificationHtml("¡Advertencia!", "warning", datali);
};

window.notificationHtml = (title, icon, html) => {
    window.Swal.fire({
        allowOutsideClick: false,
        title: title,
        icon: icon,
        html: html,
    });
};

window.confirmation = (status) => {
    let message = status == 0 ? "activar" : "bórralo";
    return Swal.fire({
        title: "Está seguro?",
        text: "¡No podrás revertir esto!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: `¡Sí, ${message}`,
        buttonsStyling: false,
        customClass: {
            confirmButton: "btn btn-success",
            cancelButton: "btn btn-danger",
        },
    });
};

// window.openModal = () => {
//     alert("test");
// }

window.requestAxios = async(endpoint, method, data) => {
    try {
        //Enviamos al servidor.
        let request = await axios({
            url: endpoint,
            method: method,
            data: data,
            //timeout: 8000,
            headers: window.headers,
        });
        //console.log(request);
        return request;
    } catch (error) {
        //console.log(error);
        return error.response;
    }
}

