<?php
namespace App\Repositories;

use Exception;
use App\Models\CreditNote;
use App\Models\Sales;
use App\Repositories\Interfaces\IReportRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class ReportRepository implements IReportRepository
{
    public function getReportSales(array $request){

        $orderBy = "id";
        if (isset($request['orderby']) && !empty($request['orderby'])) {
            $orderBy = $request['orderby'];
        }

        $orderDir = "asc";
        if (isset($request['orderdir']) && !empty($request['orderdir'])) {
            $orderDir = $request['orderdir'];
        }

        $start = "";
        if (isset($request['start']) && !empty($request['start'])) {
            $start = $request['start'];
        }

        $length = "";
        if (isset($request['length']) && !empty($request['length'])) {
            $length = $request['length'];
        }

        $search = '';

        if (isset($request['search'])) {
            $search = $request['search'];
        }
        $query = Sales::from('tec_sales as sales')->select(
            "date as fecha_venta",
            DB::raw("IF(expiration_date IS NULL, '', expiration_date) as fecha_vencimiento"),
            DB::raw("if(document_type=2,'Factura',if(document_type=1,'Boleta','Nota de venta')) as tipo_comprobante"),
            "sales.invoice_id AS nro_comprobante",
            "sales.customer_name AS nombre_cliente",
            DB::raw("customers.cf2 AS nro_documento"),
            "sales.currency AS moneda",
            "sales.affected AS afecto",
            "sales.total_tax AS IGV",
            "sales.non_affected AS no_afecto",
            "sales.exonerated AS exonerado",
            "sales.order_discount AS descuento",
            DB::raw("IF(sales.estado = 1,sales.grand_total,'0.00') AS total"),
            DB::raw("IF(sales.estado = 1, sales.paid,'0.00') AS pagado"),
            "sales.payment_method_code_sunat AS forma_pago",
            DB::raw("IF(sales.estado = 1, 'Activo','Anulado') AS estado_reg"),
            DB::raw("IF(
                sales.flg_response = 1
                and sales.error_code = 0
                and sales.estado = 0
                and sales.response_descrip like '%anulad%',
                'Anulado',
                IF(
                    sales.flg_response = 1
                    AND sales.error_code = 0
                    AND sales.estado = 0
                    AND sales.response_descrip LIKE '%pendiente%',
                    'Anulacion pendiente',
                    IF(
                        sales.flg_response = 1
                        AND sales.error_code = 0
                        AND sales.estado = 1,
                        'Procesado',
                        'Rechazado'
                    )
                )
            ) AS estado_sunat"),
            DB::raw("IF(
                sales.response_descrip IS NOT NULL,
                IF(
                    sales.response_descrip like '%genero%',
                    'SYS: Pendiente de envio a SUNAT.',
                    sales.response_descrip
                ),
                ''
            ) AS descripcion"),
            DB::raw("IF(
                sales.flg_response IS NULL
                AND sales.response_descrip IS NULL,
                'SYS: consultar con el administrador del sistema',
                ''
            ) as observaciones"),

            "users.username AS creado_por",
            "locals.name AS local"
        )
        ->leftJoin('tec_users as users', 'sales.created_by', '=', 'users.id')
        ->leftJoin('tec_customers as customers', 'customers.id', '=', 'sales.customer_id')
        ->leftJoin('tec_locals as locals', 'sales.local_id', '=', 'locals.id')
        ->leftJoin('tec_traders as traders', 'sales.trader_id', '=', 'traders.id')
        ->whereNotNull('sales.estado')
        ->whereNotNull('sales.document_type');
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$query->where('sales.estado', $request['filters']['estado']);
		}
		if (isset($request['filters']['date_start']) && $request['filters']['date_start'] != "") {
            $dateStart = Carbon::createFromFormat('d-m-Y', $request['filters']['date_start'])->startOfDay();
            $query->where('sales.date', '>=', $dateStart);
        }
		if (isset($request['filters']['date_end']) && $request['filters']['date_end'] != "") {
			$date_end = strtotime('+1 day', strtotime($request['filters']['date_end']));
			$query->where('sales.date',"<", date('Y-m-d 00:00:00', $date_end));
		}
		if (isset($request['filters']['client_id']) && $request['filters']['client_id'] != "0") {
			$query->where('customers.id', $request['filters']['client_id']);
		}
		if (isset($request['filters']['user_id']) && $request['filters']['user_id'] != "") {
			$query->where('users.id', $request['filters']['user_id']);
		}
		if (isset($request['filters']['local_id']) && $request['filters']['local_id'] != "") {
			$query->where('sales.local_id', $request['filters']['local_id']);
		}
		if (isset($request['filters']['traders_id']) && $request['filters']['traders_id'] != "") {
			$query->where('sales.trader_id', $request['filters']['traders_id']);
		}
        $tipo_comprobante = [];

        if (isset($request['tab']['boletas']) && $request['tab']['boletas'] == 1) {
            $tipo_comprobante[] = "1";
        }

        if (isset($request['tab']['facturas']) && $request['tab']['facturas'] == 1) {
            $tipo_comprobante[] = "2";
        }

        if (isset($request['tab']['notas_ventas']) && $request['tab']['notas_ventas'] == 1) {
            $tipo_comprobante[] = "3";
        }
		if(count($tipo_comprobante) > 0){
            $query->whereIn('sales.document_type',$tipo_comprobante);
        }else{
            $query->whereNotIn('sales.document_type',[0,1,2,3]);

        }
        if (!empty($search)) {
            $query->where(function ($subquery) use ($search) {
                $subquery->where('customers.name', 'like', '%' . $search . '%')
                    ->orWhere('sales.invoice_id', 'like', '%' . $search . '%')
                    ->orWhere('sales.date', 'like', '%' . $search . '%');
            });
        }
        $sales_count = $query->count();
        $query->orderBy('sales.date', $orderDir);
        if (!empty($start)) {
            $query->skip($start);
        }
        if (!empty($length)) {
            $query->take($length);
        }

        $sales = $query->get();
        $respuesta['total'] = $sales_count;
        $respuesta['list'] = $sales;
        return $respuesta;
    }
    public function getFacturas(array $request){
        $sales = Sales::from('tec_sales as sales')->select(
            "date as fecha_venta",
            DB::raw("IF(expiration_date IS NULL, '', expiration_date) as fecha_vencimiento"),
            DB::raw("'Factura' as tipo_comprobante"),
            "sales.invoice_id AS nro_comprobante",
            "sales.customer_name AS nombre_cliente",
            DB::raw("customers.cf2 AS nro_documento"),
            "sales.currency AS moneda",
            "sales.affected AS afecto",
            "sales.total_tax AS IGV",
            "sales.non_affected AS no_afecto",
            "sales.exonerated AS exonerado",
            "sales.order_discount AS descuento",
            DB::raw("IF(sales.estado = 1,sales.grand_total,'0.00') AS total"),
            DB::raw("IF(sales.estado = 1, sales.paid,'0.00') AS pagado"),
            "sales.payment_method_code_sunat AS forma_pago",
            DB::raw("IF(sales.estado = 1, 'Activo','Anulado') AS estado_reg"),
            DB::raw("IF(
                sales.flg_response = 1
                and sales.error_code = 0
                and sales.estado = 0
                and sales.response_descrip like '%anulad%',
                'Anulado',
                IF(
                    sales.flg_response = 1
                    AND sales.error_code = 0
                    AND sales.estado = 0
                    AND sales.response_descrip LIKE '%pendiente%',
                    'Anulacion pendiente',
                    IF(
                        sales.flg_response = 1
                        AND sales.error_code = 0
                        AND sales.estado = 1,
                        'Procesado',
                        'Rechazado'
                    )
                )
            ) AS estado_sunat"),
            DB::raw("IF(
                sales.response_descrip IS NOT NULL,
                IF(
                    sales.response_descrip like '%genero%',
                    'SYS: Pendiente de envio a SUNAT.',
                    sales.response_descrip
                ),
                ''
            ) AS descripcion"),
            DB::raw("IF(
                sales.flg_response IS NULL
                AND sales.response_descrip IS NULL,
                'SYS: consultar con el administrador del sistema',
                ''
            ) as observaciones"),

            "users.username AS creado_por",
            "locals.name AS local"
        )
        ->leftJoin('tec_users as users', 'sales.created_by', '=', 'users.id')
        ->leftJoin('tec_customers as customers', 'customers.id', '=', 'sales.customer_id')
        ->leftJoin('tec_locals as locals', 'sales.local_id', '=', 'locals.id')
        ->leftJoin('tec_traders as traders', 'sales.trader_id', '=', 'traders.id')
        ->whereNotNull('sales.estado')
        ->where('document_type',2);
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$sales->where('sales.estado', $request['filters']['estado']);
		}
		if (isset($request['filters']['date_start']) && $request['filters']['date_start'] != "") {
            $dateStart = Carbon::createFromFormat('d-m-Y', $request['filters']['date_start'])->startOfDay();
            $sales->where('sales.date', '>=', $dateStart);
        }
		if (isset($request['filters']['date_end']) && $request['filters']['date_end'] != "") {
			$date_end = strtotime('+1 day', strtotime($request['filters']['date_end']));
			$sales->whereDate('sales.date',"<", date('Y-m-d 00:00:00', $date_end));
		}
		if (isset($request['filters']['client_id']) && $request['filters']['client_id'] != "0") {
			$sales->where('customers.id', $request['filters']['client_id']);
		}
		if (isset($request['filters']['user_id']) && $request['filters']['user_id'] != "") {
			$sales->where('users.id', $request['filters']['user_id']);
		}
		if (isset($request['filters']['local_id']) && $request['filters']['local_id'] != "") {
			$sales->where('sales.local_id', $request['filters']['local_id']);
		}
		if (isset($request['filters']['traders_id']) && $request['filters']['traders_id'] != "") {
			$sales->where('sales.trader_id', $request['filters']['traders_id']);
		}
        $sales = $sales->get();

        return $sales;
    }
    public function getBoletas(array $request){
        $sales = Sales::from('tec_sales as sales')->select(
            "date as fecha_venta",
            DB::raw("IF(expiration_date IS NULL, '', expiration_date) as fecha_vencimiento"),
            DB::raw("'Boleta' as tipo_comprobante"),
            "sales.invoice_id AS nro_comprobante",
            "sales.customer_name AS nombre_cliente",
            DB::raw("customers.cf2 AS nro_documento"),
            "sales.currency AS moneda",
            "sales.affected AS afecto",
            "sales.total_tax AS IGV",
            "sales.non_affected AS no_afecto",
            "sales.exonerated AS exonerado",
            "sales.order_discount AS descuento",
            DB::raw("IF(sales.estado = 1,sales.grand_total,'0.00') AS total"),
            DB::raw("IF(sales.estado = 1, sales.paid,'0.00') AS pagado"),
            "sales.payment_method_code_sunat AS forma_pago",
            DB::raw("IF(sales.estado = 1, 'Activo','Anulado') AS estado_reg"),
            DB::raw("IF(
                sales.document_type = 1,
                IF(
                    sales.flg_response = 1
                    and sales.error_code = 0
                    and sales.response_descrip like '%genero%',
                    'Sin envio',
                    if(
                        sales.flg_response = 1
                        and sales.error_code = 0
                        and sales.response_descrip like '%ACEPTAD%',
                        'Procesado',
                        if(
                            sales.flg_response = 1
                            or sales.error_code = 0
                            and sales.response_descrip like '%anulad%',
                            'Anulado',
                            if(
                                sales.flg_response = 1
                                or sales.error_code = 0
                                and sales.response_descrip like '%pendiente%',
                                'Anulacion pendiente',
                                'Error de envio'
                            )
                        )
                    )
                ),
                ''
            ) AS estado_sunat"),
            DB::raw("IF(
                sales.response_descrip IS NOT NULL,
                IF(
                    sales.response_descrip like '%genero%',
                    'SYS: Pendiente de envio a SUNAT.',
                    sales.response_descrip
                ),
                ''
            ) AS descripcion"),
            DB::raw("IF(
                sales.flg_response IS NULL
                AND sales.response_descrip IS NULL,
                'SYS: consultar con el administrador del sistema',
                ''
            ) as observaciones"),

            "users.username AS creado_por",
            "locals.name AS local"
        )
        ->leftJoin('tec_users as users', 'sales.created_by', '=', 'users.id')
        ->leftJoin('tec_customers as customers', 'customers.id', '=', 'sales.customer_id')
        ->leftJoin('tec_locals as locals', 'sales.local_id', '=', 'locals.id')
        ->leftJoin('tec_traders as traders', 'sales.trader_id', '=', 'traders.id')
        ->whereNotNull('sales.estado')
        ->where('document_type',1);
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$sales->where('sales.estado', $request['filters']['estado']);
		}
		if (isset($request['filters']['date_start']) && $request['filters']['date_start'] != "") {
            $dateStart = Carbon::createFromFormat('d-m-Y', $request['filters']['date_start'])->startOfDay();
            $sales->where('sales.date', '>=', $dateStart);
        }
		if (isset($request['filters']['date_end']) && $request['filters']['date_end'] != "") {
			$date_end = strtotime('+1 day', strtotime($request['filters']['date_end']));
			$sales->where('sales.date',"<", date('Y-m-d 00:00:00', $date_end));
		}
		if (isset($request['filters']['client_id']) && $request['filters']['client_id'] != "0") {
			$sales->where('customers.id', $request['filters']['client_id']);
		}
		if (isset($request['filters']['user_id']) && $request['filters']['user_id'] != "") {
			$sales->where('users.id', $request['filters']['user_id']);
		}
		if (isset($request['filters']['local_id']) && $request['filters']['local_id'] != "") {
			$sales->where('sales.local_id', $request['filters']['local_id']);
		}
		if (isset($request['filters']['traders_id']) && $request['filters']['traders_id'] != "") {
			$sales->where('sales.trader_id', $request['filters']['traders_id']);
		}
        $sales = $sales->get();

        return $sales;
    }
    public function getSalesNote(array $request){
        $sales = Sales::from('tec_sales as sales')->select(
            "date as fecha_venta",
            DB::raw("IF(expiration_date IS NULL, '', expiration_date) as fecha_vencimiento"),
            DB::raw("'Nota de venta' as tipo_comprobante"),
            "sales.invoice_id AS nro_comprobante",
            "sales.customer_name AS nombre_cliente",
            DB::raw("customers.cf2 AS nro_documento"),
            "sales.currency AS moneda",
            "sales.affected AS afecto",
            "sales.total_tax AS IGV",
            "sales.non_affected AS no_afecto",
            "sales.exonerated AS exonerado",
            "sales.order_discount AS descuento",
            DB::raw("IF(sales.estado = 1,sales.grand_total,'0.00') AS total"),
            DB::raw("IF(sales.estado = 1, sales.paid,'0.00') AS pagado"),
            "sales.payment_method_code_sunat AS forma_pago",
            DB::raw("IF(sales.estado = 1, 'Activo','Anulado') AS estado_reg"),
            "users.username AS creado_por",
            "locals.name AS local"
        )
        ->leftJoin('tec_users as users', 'sales.created_by', '=', 'users.id')
        ->leftJoin('tec_customers as customers', 'customers.id', '=', 'sales.customer_id')
        ->leftJoin('tec_locals as locals', 'sales.local_id', '=', 'locals.id')
        ->leftJoin('tec_traders as traders', 'sales.trader_id', '=', 'traders.id')
        ->whereNotNull('sales.estado')
        ->where('document_type',3);
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$sales->where('sales.estado', $request['filters']['estado']);
		}
		if (isset($request['filters']['date_start']) && $request['filters']['date_start'] != "") {
            $dateStart = Carbon::createFromFormat('d-m-Y', $request['filters']['date_start'])->startOfDay();
            $sales->where('sales.date', '>=', $dateStart);
        }
		if (isset($request['filters']['date_end']) && $request['filters']['date_end'] != "") {
			$date_end = strtotime('+1 day', strtotime($request['filters']['date_end']));
			$sales->where('sales.date',"<", date('Y-m-d 00:00:00', $date_end));
		}
		if (isset($request['filters']['client_id']) && $request['filters']['client_id'] != "0") {
			$sales->where('customers.id', $request['filters']['client_id']);
		}
		if (isset($request['filters']['user_id']) && $request['filters']['user_id'] != "") {
			$sales->where('users.id', $request['filters']['user_id']);
		}
		if (isset($request['filters']['local_id']) && $request['filters']['local_id'] != "") {
			$sales->where('sales.local_id', $request['filters']['local_id']);
		}
		if (isset($request['filters']['traders_id']) && $request['filters']['traders_id'] != "") {
			$sales->where('sales.trader_id', $request['filters']['traders_id']);
		}
        $sales = $sales->get();

        return $sales;
    }
    public function getCreditNote(array $request){
        $credit = CreditNote::from('tec_credit_note as credit')
        ->select(
            DB::raw('concat(credit.issueDate," ",credit.issueTime) as fecha'),
            DB::raw("'Nota de crédito' as tipo_comprobante"),
            "credit.serieNumero as nro_comprobante",
            "motivos.description_NC as motivo",
            "credit.customerName as cliente",
            "credit.customerID as nro_documento",
            "credit.documentCurrencyCode as tipo_moneda",
            "credit.referenceID as comprobante_relacionado",
            "credit.taxAmount as impuesto",
            "credit.taxableAmount as afecto",
            "credit.non_affected as inafecto",
            "credit.exonerated as exonerado",
            "credit.payableAmount as total",
            "credit.description as descripcion",
            DB::raw("if(credit.estado = 1, 'Activo','Anulado') as estado_registro"),
            DB::raw("if(credit.flg_response = 1 and error_code=0, 'Aceptado','Rechazado') as estado_sunat"),
            "credit.response_descrip as respuesta_sunat",
            "users.username as creado_por"

        )
        ->leftJoin('tec_credit_note_motive as motivos', 'motivos.id', '=', 'credit.responseCode')
        ->leftJoin('tec_users as users', 'users.id', '=', 'credit.user_create');
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$credit->where('credit.estado', $request['filters']['estado']);
		}
		if (isset($request['filters']['date_start']) && $request['filters']['date_start'] != "") {
            $dateStart = Carbon::createFromFormat('d-m-Y', $request['filters']['date_start'])->startOfDay()->format('Y-m-d');
            $credit->where('credit.issueDate', '>=', $dateStart);		}
		if (isset($request['filters']['date_end']) && $request['filters']['date_end'] != "") {
			$date_end = strtotime('+1 day', strtotime($request['filters']['date_end']));
			$credit->where('credit.issueDate',"<", date('Y-m-d', $date_end));
		}
		if (isset($request['filters']['client_id']) && $request['filters']['client_id'] != "0") {
			$credit->where('customers.id', $request['filters']['client_id']);
		}
		if (isset($request['filters']['user_id']) && $request['filters']['user_id'] != "") {
			$credit->where('users.id', $request['filters']['user_id']);
		}
		if (isset($request['filters']['local_id']) && $request['filters']['local_id'] != "") {
			$credit->where('credit.local_id', $request['filters']['local_id']);
		}
		if (isset($request['filters']['traders_id']) && $request['filters']['traders_id'] != "") {
			$credit->where('credit.trader_id', $request['filters']['traders_id']);
		}
        $credit = $credit->get();
        return $credit;
    }

    function reportSireRVIE($request){

        $query = Sales::from('tec_sales as sales')->select(
            "date as fecha_emision",
            DB::raw("IF(expiration_date IS NULL, '', expiration_date) as fecha_vencimiento"),
            DB::raw("if(document_type=2,'02','01') as tipo_comprobante"),
            "sales.invoice_id AS nro_comprobante",
            "customers.document_type_id as document_type",
            DB::raw("customers.cf1 AS nro_documento"),
            DB::raw("customers.cf2 AS nro_ruc"),
            "sales.customer_name AS nombre_cliente",
            "sales.affected AS afecto",
            "sales.total_tax AS IGV",
            "sales.exonerated AS exonerado",
            "sales.non_affected AS no_afecto",
            DB::raw("IF(sales.estado = 1,sales.grand_total,'0.00') AS total"),
            "sales.currency AS moneda",
            DB::raw("IF(sales.currency = 'USD',sales.exchange,'') AS tipo_cambio"),
            "sales.order_discount AS descuento",
            DB::raw("IF(sales.estado = 1, sales.paid,'0.00') AS pagado"),
            'credit_note.issueDate as fecha_modificacion',
            'credit_note.serieNumero as nota_credito'
        )
        ->leftJoin('tec_users as users', 'sales.created_by', '=', 'users.id')
        ->leftJoin('tec_customers as customers', 'customers.id', '=', 'sales.customer_id')
        ->leftJoin('tec_locals as locals', 'sales.local_id', '=', 'locals.id')
        ->leftJoin('tec_traders as traders', 'sales.trader_id', '=', 'traders.id')
        ->leftjoin('tec_credit_note as credit_note','credit_note.referenceID','=','sales.invoice_id')
        ->whereNotNull('sales.estado')
        ->where('sales.document_type','<>',3);
        if (isset($request['filters']['estado']) && $request['filters']['estado'] != 3) {
			$query->where('sales.estado', $request['filters']['estado']);
		}

		if (isset($request['filters']['year']) && $request['filters']['year'] != "") {
			$query->where(DB::raw('year(sales.date)'), $request['filters']['year']);
			$query->where(DB::raw('month(sales.date)'), $request['filters']['month']);
		}
        $tipo_comprobante = [];

        if (isset($request['tab']['boletas']) && $request['tab']['boletas'] == 1) {
            $tipo_comprobante[] = "1";
        }

        if (isset($request['tab']['facturas']) && $request['tab']['facturas'] == 1) {
            $tipo_comprobante[] = "2";
        }
		if(count($tipo_comprobante) > 0){
            $query->whereIn('sales.document_type',$tipo_comprobante);
        }
        $sales = $query->get();

        return $sales;
    }
}
