<?php

namespace App\Repositories;

use Exception;
use App\Models\Trader;
use App\DTOs\Trader\TraderCreateDto;
use App\DTOs\Trader\TraderUpdateDto;
use App\Repositories\Interfaces\ITraderRepository;

class TraderRepository implements ITraderRepository
{
    public function paginate(array $request)
    {
        $business_information = $request['business_information'];
        $ruc = $business_information['ruc_number'];
        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];
            $query = Trader::where('status', '=', 1)->where('ruc', '=', $ruc)->orderBy($orderBy, $orderDir);
            if (isset($request['search'])) {
                $search = $request['search'];
                $query = $query->where('cod_vend', 'like', '%' . $search . '%')
                    ->orWhere('name', 'like', '%' . $search . '%');
            }
            $trader_count = $query->where('status', '=', 1)->where('ruc', '=', $ruc)->count();
            $traders = $query->skip($start)->take($length);
            $traders = $traders->where('status', '=', 1)->where('ruc', '=', $ruc)->get();
        } else {
            $ct = Trader::where('status', '=', 1)->where('ruc', '=', $ruc);
            $trader_count = $ct->count();
            $traders = $ct->get();
        }
        $respuesta['total'] = $trader_count;
        $respuesta['list'] = $traders;

        return $respuesta;
    }

    public function find(int $id): ?Trader
    {
        return Trader::find($id);
    }

    public function store(TraderCreateDto $store): Trader
    {
        $entry = new Trader();

        $entry->ruc = $store->ruc;
        $entry->cod_vend = $store->cod_vend;
        $entry->type_document = $store->type_document;
        $entry->document = $store->document;
        $entry->name = $store->name;
        $entry->last_name_1 = $store->last_name_1;
        $entry->last_name_2 = $store->last_name_2;
        $entry->birth_date = $store->birth_date;
        $entry->gender = $store->gender;
        $entry->address = $store->address;
        $entry->ubigeo = $store->ubigeo;
        $entry->movil = $store->movil;
        $entry->movil_2 = $store->movil_2;
        $entry->email = $store->email;
        $entry->type_commission = $store->type_commission;
        $entry->valor_commission = $store->valor_commission;
        $entry->observation = $store->observation;
        $entry->image = $store->image;
        $entry->user_id = $store->user_id;
        $entry->created_by = $store->created_by;

        $entry->save();

        return $entry;
    }

    public function update(TraderUpdateDto $store): void
    {
        $entry = Trader::find($store->id);

        //$entry->ruc = $store->ruc;
        $entry->cod_vend = $store->cod_vend;
        $entry->type_document = $store->type_document;
        $entry->document = $store->document;
        $entry->name = $store->name;
        $entry->last_name_1 = $store->last_name_1;
        $entry->last_name_2 = $store->last_name_2;
        $entry->birth_date = $store->birth_date;
        $entry->gender = $store->gender;
        $entry->address = $store->address;
        $entry->ubigeo = $store->ubigeo;
        $entry->movil = $store->movil;
        $entry->movil_2 = $store->movil_2;
        $entry->email = $store->email;
        $entry->type_commission = $store->type_commission;
        $entry->valor_commission = $store->valor_commission;
        $entry->observation = $store->observation;
        $entry->image = $store->image;
        $entry->user_id = $store->user_id;
        $entry->updated_by = $store->updated_by;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Trader::where('id', $id)->update([
            'status' => 0
        ]);
    }
}
