<?php

namespace App\Repositories;

use Exception;
use App\Models\Customer;
use App\DTOs\Customer\CustomerCreateDto;
use App\DTOs\Customer\CustomerUpdateDto;
use App\Repositories\Interfaces\ICustomerRepository;

class CustomerRepository implements ICustomerRepository
{
    public function paginate(array $request)
    {
        $ruc = $request['business_information']['ruc_number'];
        if($request['tipo_listado'] == 1){// para obtener el listado para la tabla de clientes
            if (
                isset($request['search']) ||
                isset($request['orderby']) ||
                isset($request['orderdir']) ||
                isset($request['start']) ||
                isset($request['length']) ||
                isset($request['filters'])
            ) {
                $orderBy = "id";
                if (isset($request['orderby']) && !empty($request['orderby'])) {
                    $orderBy = $request['orderby'];
                }

                $orderDir = "asc";
                if (isset($request['orderdir']) && !empty($request['orderdir'])) {
                    $orderDir = $request['orderdir'];
                }

                $start = "";
                if (isset($request['start']) && !empty($request['start'])) {
                    $start = $request['start'];
                }

                $length = "";
                if (isset($request['length']) && !empty($request['length'])) {
                    $length = $request['length'];
                }

                $search = '';

                if (isset($request['search'])) {
                    $search = $request['search'];
                }


                $query = Customer::select('id','name','cf1','cf2','phone','email','direccion','customers_type_id','customers_type_id','person_type','document_type_id')
                ->orderBy($orderBy, $orderDir);

                if (isset($request['filters'])) {
                    if (!empty($request['filters']['person_type'])) {
                        $query->where('person_type', '=', $request['filters']['person_type']);
                    }

                    if (!empty($request['filters']['document_type_id'])) {
                        $query->where('document_type_id', '=', $request['filters']['document_type_id']);
                    }

                    if (!empty($request['filters']['customers_type_id'])) {
                        $query->where('customers_type_id', '=', $request['filters']['customers_type_id']);
                    }
                }


                if (!empty($search)) {
                    $query->where(function ($subquery) use ($search) {
                        $subquery->where('name', 'like', '%' . $search . '%')
                            ->orWhere('cf1', 'like', '%' . $search . '%')
                            ->orWhere('cf2', 'like', '%' . $search . '%')
                            ->orWhere('phone', 'like', '%' . $search . '%')
                            ->orWhere('email', 'like', '%' . $search . '%')
                            ->orWhere('direccion', 'like', '%' . $search . '%')
                            ->orWhere('is_retainer', 'like', '%' . $search . '%')
                            ->orWhere('retainer_percentage', 'like', '%' . $search . '%');
                    });
                }

                $customer_count = $query->where('status', '=', 1)->where('ruc', '=', $ruc)->count();
                if (!empty($start)) {
                    $query->skip($start);
                }
                if (!empty($length)) {
                    $query->take($length);
                }

                $rs = $query->where('status',1)->where('ruc',$ruc)->get();
                $respuesta['list'] = $rs;
                $respuesta['total'] = $customer_count;
                return $respuesta;
            } else {
                return Customer::select('id','name','cf1','cf2','phone','email','direccion','customers_type_id','customers_type_id','person_type','document_type_id')
                ->where('status',1)->where('ruc',$ruc)->get();
            }
        }else if($request['tipo_listado'] == 2){// listado para los campos select tipo de cliente
            
            $query =  Customer::select('id','name','is_retainer','retainer_percentage','customers_type_id')
            ->where('status',1)->where('ruc',$ruc);
            
            if(isset($request['search'])){
                $search = $request['search'];
                $query->where(function ($subquery) use ($search) {
                $subquery->where('name', 'like', '%' . $search . '%')
                        ->orWhere('cf1', 'like', '%' . $search . '%')
                        ->orWhere('cf2', 'like', '%' . $search . '%');
                });
            }
            
            return $query->get();
        }
    }


    public function find(int $id, string $ruc_business): ?Customer
    {
        return Customer::where('status',1)->where('ruc',$ruc_business)->find($id);
    }

    public function store(CustomerCreateDto $store): Customer
    {
        $entry = new Customer();

        /*$entry->code = $store->code;*/

        $entry->ruc = $store->ruc;
        $entry->name = $store->name;
        $entry->cf1 = $store->cf1;
        $entry->cf2 = $store->cf2;
        $entry->phone = $store->phone;
        $entry->email = $store->email;
        $entry->direccion = $store->direccion;
        $entry->customers_type_id = $store->customers_type_id;
        $entry->created_by = $store->created_by;
        $entry->updated_by = $store->updated_by;
        $entry->created_at = $store->created_at;
        $entry->updated_at = $store->updated_at;
        $entry->status = $store->status;
        $entry->person_type = $store->person_type;
        $entry->document_type_id = $store->document_type_id;
        $entry->is_retainer = $store->is_retainer;
        $entry->retainer_percentage = $store->retainer_percentage;

        $entry->save();

        return $entry;
    }

    public function update(CustomerUpdateDto $store): void
    {
        $entry = Customer::find($store->id);

        /*$entry->code = $store->code;*/

        $entry->ruc = $store->ruc;
        $entry->name = $store->name;
        $entry->cf1 = $store->cf1;
        $entry->cf2 = $store->cf2;
        $entry->phone = $store->phone;
        $entry->email = $store->email;
        $entry->direccion = $store->direccion;
        $entry->customers_type_id = $store->customers_type_id;
        $entry->updated_by = $store->updated_by;
        $entry->updated_at = $store->updated_at;
        $entry->status = $store->status;
        $entry->person_type = $store->person_type;
        $entry->document_type_id = $store->document_type_id;
        $entry->is_retainer = $store->is_retainer;
        $entry->retainer_percentage = $store->retainer_percentage;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Customer::where('id',$id)->update([
            'status' => 0
        ]);
    }
}
