<?php

namespace App\Http\Controllers;

use App\Models\Document;
use App\Models\Serie;
use Dotenv\Regex\Success;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SerieController extends Controller
{
    private $errorConnection = '';
    private $rucNumber = '';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(Request $request)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $this->rucNumber = $business_information['ruc_number'];
            /*$ruc = $business_information['ruc_number'];
            $existe_conexion = $this->setDBClient($ruc);
            
            if($existe_conexion['error']){
                $this->errorConnection=$existe_conexion['message'];
                 return $this->messageError("Se espera un número de RUC válido.", 201); 
            }*/
        }else{
            $this->errorConnection='Error en la conexión. Se espera número de RUC';
        }
    }


    public function index(Request $request){
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
        try{

            if ((isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
                $orderBy = $request['orderby'];
                $orderDir = $request['orderdir'];
                $start = $request['start'];
                $length = $request['length'];
                $query= $series = Serie::orderBy($orderBy, $orderDir)->where('ruc_number', '=', $this->rucNumber);
                if(isset($request['documentid'])){
                    $document_type_id = $request['documentid'];
                    $query=$query->where('document_type_id', '=',  $document_type_id);
                }
                if (isset($request['search'])) {
                    $search = $request['search'];
                    $query=$query->where('description', 'like', '%'. $search.'%');
                }   
                $series_count=$query->count();
                $series=$query->skip($start)->take($length);
                $series=$series->get();
                  
            } else {
                $se = Serie::query()->where('ruc_number', '=', $this->rucNumber);
                $series_count=$se->count();
                $series = $se->get();
            } 
            $respuesta['total']=$series_count;
            $respuesta['list']=$series;


             if( count($series) > 0){
                 return $this->successResponse($respuesta, "", 201);
             } else {
                 return $this->successResponse($respuesta,"No hay Series cargadas en el sistema.", 201);
             }

         } catch(\Exception $ex){
             echo $ex->getMessage();
             return $this->messageError("Ocurrió un error al buscar las Series cargadas en el sistema.", 201);
         }
    }

    public function getSeriesDocument(Request $request, $id = null){
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
        try{
            if ((isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
                $orderBy = $request['orderby'];
                $orderDir = $request['orderdir'];
                $start = $request['start'];
                $length = $request['length'];
                $query= Serie::orderBy($orderBy, $orderDir)->where('ruc_number', '=', $this->rucNumber);
                if($id != null){
                    $query=$query->where('document_type_id', '=',  $id);
                }
                if (isset($request['search'])) {
                    $search = $request['search'];
                    $query=$query->where('description', 'like', '%'. $search.'%');
                }   
                $series_count=$query->count();
                $series=$query->skip($start)->take($length);
                $series=$series->get();
                  
            } else {
                $se = Serie::query()->where('ruc_number', '=', $this->rucNumber);
                $series_count=$se->count();
                $series = $se->get();
            } 
            $respuesta['total']=$series_count;
            $respuesta['list']=$series;


             if( count($series) > 0){
                 return $this->successResponse($respuesta, "", 201);
             } else {
                 return $this->successResponse($respuesta,"No hay Series cargadas en el sistema.", 201);
             }

         } catch(\Exception $ex){
             echo $ex->getMessage();
             return $this->messageError("Ocurrió un error al buscar las Series cargadas en el sistema.", 201);
         }
    }

    public function show(int $id){
         if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
      
       try{
           if($id != ""){
                $serie= Serie::where('ruc_number', '=', $this->rucNumber)->find($id);
           }else{
                $serie=null;
           }
            
            if( $serie === null){
                return $this->messageError("No hay datos para la Serie buscada.", 201);
            } else {
                return $this->successResponse($serie, "", 201);
            }
        } catch(\Exception $ex){
            return $this->messageError("Ocurrió un error al buscar las Series cargadas en el sistema.", 201);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request){
        try{
            if($this->errorConnection != ''){
                return $this->messageError($this->errorConnection, 201); 
            }
            $rules = [
                'serie' => ['required','max:4','regex:/^[A-Za-z0-9 ]+$/'],
                'document_type_id' => ['required'],
                'correlative' => ['required','integer','digits_between :1, 8'],
                'description' => ['max:200']
            ];
            $messages = [
                'serie.required' => 'El código de Serie no puede estar vacío.',
                'serie.max' =>'El código de Serie no puede ser mayor a :max caracteres.',
                'serie.regex' =>'El código de Serie no puede contenter caracteres especiales.',
                'document_type_id.required' => 'Debe seleccionar un tipo de Documento.',
                'correlative.required' => 'El número de Correlativo no puede estar vacío.',
                'correlative.integer' => 'El número Correlativo debe ser un número entero.',
                'correlative.digits_between' => 'El número Correlativo debe tener como mínimo :min dígito y como máximo :max.',
                'description.max' => 'La Descripción no puede superar los :max caracteres.'
            ];
            $this->validate($request, $rules, $messages);
            
    
            $serie=$request['serie'];
            $document_type_id=$request['document_type_id'];
            $serieExist= Serie::where('serie','like', $serie)->->where('document_type_id', '=', $document_type_id)
                ->where('ruc_number', '=', $this->rucNumber)->get();
            $countable=count($serieExist);
            if($countable >0 ){
                return $this->messageError("La Serie ya se encuentra cargada en el sistema.", 201);
            }
            $input = $request->all();
            $input['ruc_number'] = $this->rucNumber;
            if(!(Document::find($document_type_id))){
                return $this->messageError("No se encuentra el documento asociado.", 201,$document_type_id);
            }
            $serie = Serie::create($input);
            if( !is_null($serie) ){
                return $this->successResponse($serie, "La Serie se creó correctamente", 201);
            }
        }catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        } catch(\Exception $ex){
            return $this->errorResponse($ex->getMessage(), 201);
        }    

        return $this->messageError("Ocurrió un error creando Serie.", 201);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     * @throws \Illuminate\Validation\ValidationException
     */
    public function update(Request $request, $id)
    {
         if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
       
        try{
            $rules = [
                'serie' => ['required','max:4','regex:/^[A-Za-z0-9 ]+$/'],
                'document_type_id' => ['required'],
                'correlative' => ['required','integer','digits_between :1, 8'],
                'description' => ['max:200']
            ];
            $messages = [
                'serie.required' => 'El código de Serie no puede estar vacío.',
                'serie.max' =>'El código de Serie no puede ser mayor a :max caracteres.',
                'serie.regex' =>'El código de Serie no puede contenter caracteres especiales.',
                'document_type_id' => 'Debe seleccionar un tipo de Documento.',
                'correlative.required' => 'El número de Correlativo no puede estar vacío.',
                'correlative.integer' => 'El número Correlativo debe ser un número entero.',
                'correlative.digits_between' => 'El número Correlativo debe tener como mínimo :min dígito o como máximo :max.',
                'description.max' => 'La Descripción no puede superar los :max caracteres.'
            ];
            $this->validate($request, $rules, $messages);
            $serie=$request['serie'];
            $document_type_id=$request['document_type_id'];
    
            $serieExist= Serie::where('serie','=', $serie)->where('document_type_id', '=', $document_type_id)
                ->where('ruc_number', '=', $this->rucNumber)->first();
            if(!is_null($serieExist)){
                $idexist= $serieExist->id;
    
                if($idexist != $id){
                    return $this->messageError("La Serie ya se encuentra cargada en el sistema.", 201);
                }
    
            }
            
            $input = $request->all();
            $input['ruc_number'] = $this->rucNumber;
            if(!(Document::find($document_type_id))){
                return $this->messageError("No se encuentra el documento asociado.", 201,$document_type_id);
            }
            $serie = Serie::where('document_type_id', '=', $document_type_id)->where('ruc_number', '=', $this->rucNumber)->find($id);
            //$serie = Serie::find($id);
            if( !is_null($serie) ) {
                if ($serie->fill($input)->save()) {
                    return $this->successResponse($serie, "La Serie se actualizó correctamente", 201);
                }
            } else {
                return $this->messageError("No existe la Serie para el RUC asociado.", 201);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        } catch(\Exception $ex){

        }  

        return $this->messageError("Ocurrió un error al actualizar la Serie.", 201);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(int $id)
    {
         if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
       
        try{
            if( Serie::where('ruc_number', '=', $this->rucNumber)->where('id', '=', $id)->delete() ){
                return $this->messageSuccess("La Serie se eliminó correctamente", 201);
            } else {
                return $this->messageError("No se pudo eliminar la Serie.", 201);
            }
        } catch(\Exception $ex) {
            return $this->messageError("Ocurrió un error al eliminar la Serie.".$ex->getMessage(), 201);
        }
    }

}