<?php
namespace App\Providers;

use App\Repositories\OperationTypeRepository;
use App\Repositories\PaymentMethodRepository;
use Illuminate\Support\ServiceProvider;
use App\Repositories\Interfaces\IPaymentMethodRepository;
use App\Repositories\Interfaces\ISettingRepository;
use App\Repositories\SettingRepository;
use App\Repositories\Interfaces\IAffectationTypeRepository;
use App\Repositories\AffectationTypeRepository;
use App\Repositories\DetractionTypeRepository;
use App\Repositories\Interfaces\IDetractionTypeRepository;
use App\Repositories\Interfaces\IOperationTypeRepository;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(IPaymentMethodRepository::class, PaymentMethodRepository::class);
        $this->app->bind(ISettingRepository::class, SettingRepository::class);
        $this->app->bind(IAffectationTypeRepository::class, AffectationTypeRepository::class);
        $this->app->bind(IDetractionTypeRepository::class, DetractionTypeRepository::class);
        $this->app->bind(IOperationTypeRepository::class, OperationTypeRepository::class);


    }
}
