<?php 

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Repositories\Interfaces\IAffectationTypeRepository;
use Illuminate\Http\Request;

class AffectationTypeController extends Controller
{
    private $iAffectationTypeRepository;

    public function __construct(IAffectationTypeRepository $iAffectationTypeRepository){
        $this->iAffectationTypeRepository = $iAffectationTypeRepository;
    }
    public function index(Request $request){
        $datos = $request->all();
        if(empty($datos)){
            $datos = array("flagGratuito" => "0");
        }
        $tipoAfectacionData = $this->iAffectationTypeRepository->get($datos);
        return $tipoAfectacionData;
    }
    //implementar el metodo show
    public function show($id){
        $tipoAfectacionData = $this->iAffectationTypeRepository->find($id);
        return $tipoAfectacionData;
    }
}
