<?php
/**
 * Created by PhpStorm.
 * User: juan
 * Date: 12/1/2021
 * Time: 03:11
 */

namespace App\Http\Controllers;

use GuzzleHttp\Client as HttpClient;
use Illuminate\Http\Request;

class DniController extends Controller
{

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        try{
            $dninro = $request->sNroDocumento;
            $dniendpoint = config("constantes.api_dni");
            $token = config("constantes.api_rucdni_token");

            $client = new HttpClient();
            $res = $client->request('POST', $dniendpoint, [
                'headers' => [
                    'Accept' => 'application/json',
                ],
                'json' => [
                    'token' => $token,
                    'dni' => $dninro
                ],
                'verify' => false
            ]);
            /*var_dump($res->getBody());
            var_dump(json_decode($res->getBody(), true));
            exit();*/
            $resp_arr = json_decode($res->getBody(), true);
            /*exit();
            $client = new HttpClient();
            $response = $client->request('GET', $rucendpoint, ['query' => [
                'sNroDocumento' => $rucnro
            ], 'verify' => false]);

            $resp_arr = json_decode($response->getBody(), true);*/

            if( isset($resp_arr['success']) ){
                return $this->successResponse($resp_arr, "", 201);
            } else {
                return $this->messageError("No hay datos para el DNI buscado.", 201);
            }
        } catch(\Exception $ex){
            return $this->messageError("Ocurrió un error al buscar el DNI.", 500);
        }
    }

}