<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DTOs\Supplier\SupplierCreateDto;
use App\DTOs\Supplier\SupplierUpdateDto;
use App\Repositories\Interfaces\ISupplierRepository;
use Exception;
use App\Models\Supplier;

class SupplierController extends Controller
{

    private $supplierRepository;
    private $errorConnection = "";

    public function __construct(Request $request, ISupplierRepository $supplierRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];

            $existe_conexion = $this->setDBClient($ruc);

            if($existe_conexion['error']){
                $this->errorConnection=$existe_conexion['message'];
                return $this->messageError("Se espera un número de RUC válido.", 201); 
            } else {
                $this->supplierRepository = $supplierRepository;
            }
        } else {
            $this->errorConnection='Error en la conexión. Se espera número de RUC';
        }
    }

    public function index(Request $request)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }

        $result = $this->supplierRepository->paginate($request->all());    

        if ($result) {
            return $this->successResponse($result, "Proveedores encontrados correctamente", 201);
        } else {
            return $this->errorResponse("No hay Proveedores", 201);
        }
    }

    public function show(int $id)
    {
        
    }

    public function store(Request $request)
    {        
        
    }

    public function update(int $id, Request $request)
    {
        
    }

    public function destroy(int $id)
    {
        
    }    
}
