<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});


$router->group(['prefix' => 'api/v1/'], function ($app) {
    $app->group(['prefix' => 'supplier'], function () use ($app) {
        $app->get('/', 'SupplierController@index');
        $app->get('/{id}', 'SupplierController@show');
        $app->post('/', 'SupplierController@store');
        $app->put('/{id}', 'SupplierController@update');
        $app->delete('/{id}', 'SupplierController@destroy');
    });
});