<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DTOs\Makers\MakersCreateDto;
use App\DTOs\Makers\MakersUpdateDto;
use App\Repositories\Interfaces\IMakersRepository;
use Exception;
use App\Models\Makers;

class MakersController extends Controller
{

    private $makersRepository;

    private $errorConnection = "";

    public function __construct(Request $request, IMakersRepository $makersRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];

            $existe_conexion = $this->setDBClient($ruc);

            if($existe_conexion['error']){
                $this->errorConnection=$errorConnection['message'];
                return $this->messageError("Se espera un numero de RUC valido.", 201);
            } else {
                $this->makersRepository = $makersRepository;
            }
        } else {
            $this->errorConnection='Error en la conexion. Se espera numero de RUC';
        }
    }

    public function index(Request $request)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201);
        }

        $result = $this->makersRepository->paginate($request->all());

        if ($result) {
            if( $result['total'] > 0){
                return $this->successResponse($result, "fabricantes encontrados correctamente.", 201);
            } else {
                return $this->successResponse($result, "No hay Series cargadas en el sistema.", 201);
            }
        } else {
            return $this->errorResponse("No hay Fabricantes.", 201);
        }
    }

    public function show(int $id)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201);
        }

        $result = $this->makersRepository->find($id);

        if ($result) {
            return $this->successResponse($result, "Fabricante encontrada correctamente", 201);
        } else {
            return $this->errorResponse("Fabricante no encontrada", 201);
        }
    }

    public function store(Request $request)
    {
        try {
            if($this->errorConnection != ''){
                return $this->messageError($this->errorConnection, 201);
            }
                $this->validate($request, [
                    'maker' => 'required|max:250'
                ], [
                    'maker.required' => 'El nombre del fabricante es requerido'
                ]);

                $store = new MakersCreateDto($request->except('business_information'));
                $result = $this->makersRepository->store($store);

                return $this->successResponse($result, "El fabricante fue creado correctamente", 201);
                
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }
    }

    public function update(int $id, Request $request)
    {
        try {
            if($this->errorConnection != '') {
                return $this->messageError($this->errorConnection, 201);
            }
            $result = $this->makersRepository->find($id);

            $this->validate($request, [
                'maker' => 'required|max:250'
            ], [
                'maker.required' => 'El Nombre de Fabricante es requerido'
            ]);

            $data = $request->except('business_information');
            $data['id'] = $id;

            $entry = new MakersUpdateDto($data);

            $this->makersRepository->update($entry);

            $result = $this->makersRepository->find($id);

            return $this->successResponse($result, "El fabricante fue actualizado correctamente", 201);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }
        
    }

    public function destroy(int $id)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201);
        }
        $result = $this->makersRepository->find($id);

        if ($result) {
            $this->makersRepository->destroy($id);

            return $this->successResponse($id, "Fabricante Eliminado correctamente", 201);
        } else {
            return $this->errorResponse("Fabricante Ingresada no existe", 201);
        }
    }

}