<?php

namespace App;

use App\Traits\ApiResponser;
use Illuminate\Auth\Authenticatable;
use Laravel\Lumen\Auth\Authorizable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class PersonaModel extends Model 
{
  use ApiResponser;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
protected $table='personas';
    //protected $table = [
     //   'tipo','nombre', 'nom_corto',
    //];

    public function empresa(){
        return $this->hasOne('App\EmpresaModel', 'id_persona', 'id_persona');
    }

    public function ListarPersonas(){
        try {
           $documents= DB::select('SP_ADMIN_LISTAR_PERSONAS()');
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    public function obtenerRuc($idPersona){
        try {
            $persona = self::select('num_documento as ruc')->where('id_persona', '=', $idPersona)->first();
            return $persona;           
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    public function obtenerEstadoDeuda($ruc){
        try {
            // $deuda = DB::table('empresas as e')
            // ->join('personas as p', 'e.id_persona', '=', 'p.id_persona')
            // ->where('p.num_documento', '=', $ruc)
            // ->select('e.id_ticket_pen')
            // ->first();
            $deuda = DB::table('empresas as e')
            ->join('personas as p', 'e.id_persona', '=', 'p.id_persona')
            ->join('tickets as t', 'e.id_empresa', '=', 't.id_empresa')
            ->where('p.num_documento', '=', $ruc)
            ->select('e.id_ticket_pen', 't.numero', 't.fec_vencimiento', 't.imp_total')
            ->get();
            return $deuda;           
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    public function EditarPersona($data){
        try {
           $documents= DB::select('SP_ADMIN_EDITAR_PERSONA()');
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    public function ListarPersonaPorId($id){
        try {
           $documents= DB::select('SP_ADMIN_LISTAR_PERSONA_ID(?)',['id'=>$id]);
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    public function EliminarPersona($id){
        try {
           $documents= DB::select('SP_ADMIN_ELIMINAR_PERSONA(?)',[$id]);
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
