DELIMITER $$

DROP PROCEDURE IF EXISTS `SP_ADMIN_LISTAR_EMPRESAS_POR_RUC`$$

CREATE  PROCEDURE SP_ADMIN_LISTAR_EMPRESAS_POR_RUC(
    IN pvar_ruc varchar(11)
    )
BEGIN
	select 
		emp.id_empresa,
		per.tip_persona,
		tdoc.tipo as codigo_doc,
		per.num_documento,
		if(per.tip_persona=2, 
				per.nombres ,
					concat(per.nombres," ",per.ape_paterno," ",per.ape_materno )
			) as razon_social,
		if(per.tip_persona=2,
			per.num_documento,
				if(per.ruc!='' or per.ruc!= null,
						per.ruc,per.num_documento)
		  ) as documento,
		emp.direccion,
		emp.db_host,
		emp.db_name,
		emp.db_usuario,
		emp.db_contrasena
		from personas per 
			inner join tiposdocumento tdoc
				on per.id_tip_doc=tdoc.id_tip_doc
			inner join empresas emp 
				on per.id_persona=emp.id_persona
		where per.num_ducumento=pvar_ruc
			and emp.status=1;
END$$

DELIMITER ;