<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableTickets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->increments('id_ticket');
            $table->integer('id_empresa')->nullable();
            $table->string('numero',10);
            $table->char('fec_emision',1);
            $table->date('fec_vencimiento');
            $table->char('periodo',6);
            $table->decimal('imp_total');
            $table->dateTime('fec_pago');
            $table->char('flg_reconexion',2);
            $table->char('estado',1);
            $table->string('created_user',10)->nullable();
            $table->string('updated_user',10)->nullable();
            $table->timestamps();
            $table->integer('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tickets');
    }
}
