<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableEmpresas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('empresas', function (Blueprint $table) {
            $table->increments('id_empresa');
            $table->integer('id_persona')->nullable();
            $table->string('direccion')->nullable();
            $table->integer('ubigeo');
            $table->string('sub_dominio');
            $table->string('db_host');
            $table->string('db_name');
            $table->string('db_usuario');
            $table->string('db_contrasena');
            $table->dateTime('fec_afiliacion');
            $table->dateTime('fec_suspencion');
            $table->dateTime('fec_cancelacion');
            $table->integer('id_vendedor')->nullable();
            $table->char('flg_reconexion');
            $table->char('estado');
            $table->string('created_user')->nullable();
            $table->string('updated_user')->nullable();
            $table->timestamps();
            $table->integer('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('empresas');
    }
}
