<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTablePersonas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personas', function (Blueprint $table) {
            $table->increments('id_persona');
            $table->integer('id_tip_doc')->nullable();
            $table->string('num_documento',8);
            $table->char('tip_persona',1);
            $table->string('nombres',50);
            $table->string('ape_paterno',20);
            $table->string('ape_materno',20);
            $table->string('ruc',11)->nullable();
            $table->string('created_user',5)->nullable();
            $table->string('updated_user',5)->nullable();
            $table->timestamps();
            $table->integer('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personas');
    }
}
