<?php

namespace App;

use App\Traits\ApiResponser;
use Illuminate\Auth\Authenticatable;
use Laravel\Lumen\Auth\Authorizable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class PersonaModel extends Model 
{
  use ApiResponser;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
protected $table='personas';
    //protected $table = [
     //   'tipo','nombre', 'nom_corto',
    //];

    public function empresa(){
        return $this->hasOne('App\EmpresaModel', 'id_persona', 'id_persona');
    }

    public function ListarPersonas(){
        try {
           $documents= DB::select('SP_ADMIN_LISTAR_PERSONAS()');
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
       
    }
    public function EditarPersona($data){
        try {
           $documents= DB::select('SP_ADMIN_EDITAR_PERSONA()');
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
       
    }
    public function ListarPersonaPorId($id){
        try {
           $documents= DB::select('SP_ADMIN_LISTAR_PERSONA_ID(?)',['id'=>$id]);
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
       
    }
    public function EliminarPersona($id){
        try {
           $documents= DB::select('SP_ADMIN_ELIMINAR_PERSONA(?)',[$id]);
           return $this->SuccessResponse($documents);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
       
    }

}
