<?php
namespace App\Http\Controllers;

use DB;
use App\Models\Prueba;
use App\PersonaModel;
use GuzzleHttp\Client as HttpClient;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Traits\Responser;

class ClientsController extends Controller
{
    use Responser;

    public function show($ruc)
    {
        try{
            $datosEmp = [];
            $persona = PersonaModel::where('num_documento', '=', $ruc)->get();
            if( count($persona) > 0 ){
                $persona = $persona->first()->empresa;
                if( !is_null($persona) ){
                    $datosEmp['host_BD'] = $persona->db_host;
                    $datosEmp['BD_sistema'] = $persona->db_name;
                    $datosEmp['usuario_BD'] = $persona->db_usuario;
                    $datosEmp['password_BD'] = $persona->db_contrasena;
                    $datosEmp['subdominio'] =$persona->sub_dominio;
                    $datosEmp['flg_reconexion']=$persona->flg_reconexion; //para pasar a git
                    $datosEmp['estado']=$persona->estado;//para pasar a git
                    return $this->successResponse($datosEmp, "Cliente econtrado correctamente.", 201);
                } else {
                    return $this->errorResponse("La persona no tiene una empresa asociada.", 201);
                }
            } else {
                return $this->errorResponse("Cliente no encontrado", 201);
            }
        }catch(\Exception $ex){
            return $this->errorResponse($ex->getMessage(),500);
        }
    }

}