<?php

namespace App;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Traits\ApiResponser;
use Illuminate\Http\Response;

class EmpresaModel extends Model
{
    use ApiResponser;
    protected $table='empresas';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
  //  protected $fillable = [
    //    'name', 'email',
   // ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
   // protected $hidden = [
   //     'password',
    //];
    public function getBusiness(){
        try {
            $res=DB::select('call SP_ADMIN_LISTAR_EMPRESAS()');
            
        return $this->SuccessResponse($res,Response::HTTP_OK);
        } catch (\Throwable $th) {
           return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
       }

    }
    public function insertBusiness($data){
        try {
            $business=DB::select("call SP_ADMIN_AGREGAR_EMPRESAS(
                ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",[
                $data["id_tip_doc"],
                $data["num_documento"],
                $data["tip_persona"],
                $data["nombres"],
                $data["ape_paterno"],
                $data["ape_materno"],
                $data["ruc"],
                $data["id_tip_doc_contacto"],
                $data["num_documento_contacto"],
                $data["nombre_contacto"],
                $data["ape_paterno_contacto"],
                $data["ape_materno_contacto"],
                $data["email1_contacto"],
                $data["email2_contacto"],
                $data["movil1_contacto"],
                $data["movil2_contacto"],
                $data["movil3_contacto"],
                $data["direccion"],
                $data["ubigeo"],
                $data["subdominio"],
                $data["host_db"],
                $data["db_sistema"],
                $data["user_db"],
                $data["password_db"],
                $data["user_created"]

            ]);
			
			
			
			$result[0]=$business['0']->var_mensaje;
			$result[1]=$this->SuccessResponse($business,Response::HTTP_CREATED);
			
        return $result;
            } catch (\Throwable $th) {
				$result[0]=0;
				$result[1]=$this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
            return $result;
        }



    }

    public function listarEmpresasPorRUC($ruc){
        try {
            $business=DB::select("call SP_ADMIN_LISTAR_EMPRESAS_POR_RUC(?)",[$ruc]);
            return $this->SuccessResponse($business,Response::HTTP_OK);
        } catch (\Throwable $th) {
           return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }


    }
    public function listarEmpresasPorId($id){
        try {

            
            $business=DB::select("call SP_ADMIN_LISTAR_EMPRESAS_POR_ID(?)",[$id]);
            return $this->SuccessResponse($business,Response::HTTP_OK);
        } catch (\Throwable $th) {
           return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }


    }
    public function updateBusiness($data,$id){
        try {
            $business=DB::select("call SP_ADMIN_EDITAR_EMPRESA(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",[
                $id,
                $data["id_tip_doc"], 
                $data["num_documento"], 
                $data["tip_persona"], 
                $data["nombres"], 
                $data["ape_paterno"], 
                $data["ape_materno"], 
                $data["ruc"],
                $data["id_tip_doc_contacto"], 
                $data["num_documento_contacto"], 
                $data["nombre_contacto"], 
                $data["ape_paterno_contacto"], 
                $data["ape_materno_contacto"], 
                $data["email1_contacto"],
                $data["email2_contacto"], 
                $data["movil1_contacto"],
                $data["movil2_contacto"],
                $data["movil3_contacto"], 
                $data["direccion"], 
                $data["ubigeo"],
                $data["estado"],
                $data["user_updated"]


            ]);
            return $this->SuccessResponse($business,Response::HTTP_OK);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
    public function deleteBusiness($id){
        try {
            $res=DB::select('call SP_ADMIN_ELIMINAR_EMPRESAS(?)',[$id]);
        return $this->SuccessResponse($res,Response::HTTP_OK);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th,Response::HTTP_INTERNAL_SERVER_ERROR);
        }

    }

}
