<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|   example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|   http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|   $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|   $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|   $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples: my-controller/index -> my_controller/index
|       my-controller/my-method -> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';;
$route['translate_uri_dashes'] = FALSE;

$route['login'] = 'auth/login';
$route['logout'] = 'auth/logout';
$route['users'] = 'auth/users';
$route['users/profile/(:num)'] = 'auth/profile/$1';
$route['users/add'] = 'auth/create_user';

$route['guides_entrance/(:any)'] = 'guide/index/i';
$route['guides_departure/(:any)'] = 'guide/index/s';
// $route['guides_entrance'] = 'guide';
// $route['guides_departure'] = 'guide';

$route['guides/get/(:any)'] = 'guide/get_guides/$1';
$route['guides/entrance/(:num)'] = 'guide/addEntrance';
$route['guides/departure/(:num)'] = 'guide/addEntrance';
$route['guides/get_products'] = 'products/get_all';
$route['guides/get_product/(:num)'] = 'products/get_product/$1';
$route['guides/new'] = 'guide/store_guide';
$route['guides/update/(:num)'] = 'guide/update/$1';
$route['guides/addReg_guide'] = 'guide/addReg_guide';
$route['guides/get_exchange'] = 'guide/get_exchange';
$route['guides/deleteReg/(:num)'] = 'guide/deleteReg/$1';
$route['guides/updateReg/(:num)'] = 'guide/updateReg/$1';
$route['guides/createReg'] = 'guide/createReg';

$route['documents'] = 'document_type';
$route['documents/list'] = 'document_type';
$route['documents/get_documents'] = 'document_type/get_documents';
$route['documents/all'] = 'document_type/documents_all';
$route['documents/show/(:num)'] = 'series/index/$1';

$route['series/get'] = 'series/get_series/';
$route['series/get/(:num)'] = 'series/get_series/$1';
$route['series/show/(:num)'] = 'series/get_serie_by_serie/$1';
$route['series/save'] = 'series/edit';
$route['series/new'] = 'series/store';
$route['series/delete/(:num)/(:num)'] = 'series/delete/$1/$1';



$route['pos/(:num)'] = 'pos/index/$1';

$route['invoices'] = 'summaries/invoices';