$(document).ready(function() {
    $('#departament').change(function(e) {
        var departament = $(this).val();
        loadProvince(departament);
    });
    $('#province').change(function(e) {
        var departament = $("#dapartament").val();
        var province = $(this).val();
        loadDistrict(departament, province);
    });

    $('#search-doc').click(function(e) {
        var documentNumber = $('#documentNumber').val();
        console.log(documentNumber);

        if (documentNumber == "") {
            alert('inserte un numero de documento');

        } else {
            $.ajax({
                type: "method",
                url: base_url + "general/get_data_by_dni/" + documentNumber,
                data: "data",
                dataType: "json",
                success: function(response) {
                    if (response.result == 'ok') {
                        var nombreCompleto = response.data.nombre;
                        var nombre = nombreCompleto.split(' ');

                        if (nombre.length > 3) {
                            var segundoNombre = " " + nombre[3];
                        } else {
                            var segundoNombre = "";
                        }
                        $("#name").val(nombre[2] + segundoNombre);
                        $("#fathersLastName").val(nombre[0]);
                        $("#MotherLastName").val(nombre[1]);
                    } else {
                        alert(response.message);
                    }

                }
            });
        }

    });

    $('#btn-cancel').click(function(e) {
        if (confirm("¿Está seguro que desea cancelar?")) {
            window.location.href = base_url + "traders"
        }

    });
});

function loadProvince(departament) {
    var departament = departament;
    $.ajax({
        type: "get",
        url: base_url + 'traders/search_province/' + departament,
        dataType: "json",
        async: false,
        success: function(response) {
            $("#province").prop('disabled', false);
            $("#district").prop('disabled', true);
            $('option', '#province').remove();
            $('option', '#district').remove();
            $("#province").append('<option value="0">SELECCIONAR</option>');
            $("#district").append('<option value="0">SELECCIONAR</option>');
            $.each(response.data, function(key, registro) {
                $("#province").append('<option value="' + registro.codProv + '">' + registro.provincia + '</option>');
            });
        }
    });
}

function loadDistrict(departament, province) {

    var departament = departament;
    var province = province;
    $.ajax({
        type: "get",
        url: base_url + 'traders/search_District/' + province + '/' + departament,
        dataType: "json",
        async: false,
        success: function(response) {
            $("#district").prop('disabled', false);
            $('option', '#district').remove();
            $("#district").append('<option value="0">SELECCIONAR</option>');
            $.each(response.data, function(key, registro) {
                $("#district").append('<option value=' + registro.ubigeo + '>' + registro.distrito + '</option>');
            });
        }
    });

}